--------------------------------------------------------------------------------
Library IEEE;
Use IEEE.Std_Logic_1164.all;
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
Entity configurable_u_lax Is
  Port(
      CLK : in    std_logic;
      CLK_CAP : in    std_logic;
      EXT_TRIGGER : in    std_logic;
      BUS_PH0 : in   std_logic;
      BUS_PH1 : in   std_logic;
      Z80_CLK : in   std_logic;
      BUS_7M : in   std_logic;
      DIN2ul : in   std_logic;
      DIN2 : in   std_logic;
      DIN3ul : in   std_logic;
      DIN3 : in   std_logic;
      DIN4ul : in   std_logic;
      DIN4 : in   std_logic;
      DIN5ul : in   std_logic;
      DIN5 : in   std_logic;
      DIN6ul : in   std_logic;
      DIN6 : in   std_logic;
      DIN7ul : in   std_logic;
      DIN7 : in   std_logic;
      STATUS : out   std_logic;
      TCK : in   std_logic;
      TDI : in   std_logic;
      TDO : out   std_logic;
      TMS : in   std_logic;
      TRST : in   std_logic
      );
End configurable_u_lax;
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
Architecture structure of configurable_u_lax is

   Component LAX_CFG16
      port
      (
        CH_TRIG  : in  STD_LOGIC_VECTOR(15 downto 0);
        CH_CAP   : in  STD_LOGIC_VECTOR(15 downto 0);
        CLK      : in  STD_LOGIC;
        CLK_CAP  : in  STD_LOGIC;
        STATUS   : out STD_LOGIC;
        DATAO    : out STD_LOGIC_VECTOR(15 downto 0);
        DATAI    : in  STD_LOGIC_VECTOR(15 downto 0);
        ADDR     : out STD_LOGIC_VECTOR(19 downto 0);
        WR       : out STD_LOGIC;
        RD       : out STD_LOGIC;
        SEL_CAP  : out STD_LOGIC_VECTOR(3 downto 0);
        SEL_TRIG : out STD_LOGIC_VECTOR(3 downto 0);
        TCK      : in  STD_LOGIC;
        TDI      : in  STD_LOGIC;
        TDO      : out STD_LOGIC;
        TMS      : in  STD_LOGIC;
        TRIGGER  : in  STD_LOGIC;
        TRST     : in  STD_LOGIC
      );
   End Component;

   Component memory_u_lax
      port
      (
        CLK      : in  STD_LOGIC;
        WE       : in  STD_LOGIC;
        ADDR     : in  STD_LOGIC_VECTOR(9 downto 0);
        DIN      : in  STD_LOGIC_VECTOR(15 downto 0);
        DOUT     : out STD_LOGIC_VECTOR(15 downto 0)
      );
   End Component;

   Signal Unique_Lax_Signal_Name_Mem_WE   : STD_LOGIC;
   Signal Unique_Lax_Signal_Name_Mem_DIN  : STD_LOGIC_VECTOR(15 downto 0);
   Signal Unique_Lax_Signal_Name_Mem_DOUT : STD_LOGIC_VECTOR(15 downto 0);

   Signal Unique_Lax_Signal_Name_Mem_ADDR : STD_LOGIC_VECTOR(19 Downto 0);
   Signal Unique_Lax_Signal_Name_selcap   : STD_LOGIC_VECTOR(3 downto 0);
   Signal Unique_Lax_Signal_Name_seltrig  : STD_LOGIC_VECTOR(3 downto 0);
   Signal Unique_Lax_Signal_Name_capin    : STD_LOGIC_VECTOR(15 downto 0);
   Signal Unique_Lax_Signal_Name_trigin   : STD_LOGIC_VECTOR(15 downto 0);


Begin
    Unique_Lax_Signal_Name_capin(0) <= BUS_PH0;
    Unique_Lax_Signal_Name_trigin(0) <= BUS_PH0;
    Unique_Lax_Signal_Name_capin(1) <= BUS_PH1;
    Unique_Lax_Signal_Name_trigin(1) <= BUS_PH1;
    Unique_Lax_Signal_Name_capin(2) <= Z80_CLK;
    Unique_Lax_Signal_Name_trigin(2) <= Z80_CLK;
    Unique_Lax_Signal_Name_capin(3) <= BUS_7M;
    Unique_Lax_Signal_Name_trigin(3) <= BUS_7M;
    Unique_Lax_Signal_Name_capin(4) <= DIN2ul;
    Unique_Lax_Signal_Name_trigin(4) <= DIN2ul;
    Unique_Lax_Signal_Name_capin(5) <= DIN2;
    Unique_Lax_Signal_Name_trigin(5) <= DIN2;
    Unique_Lax_Signal_Name_capin(6) <= DIN3ul;
    Unique_Lax_Signal_Name_trigin(6) <= DIN3ul;
    Unique_Lax_Signal_Name_capin(7) <= DIN3;
    Unique_Lax_Signal_Name_trigin(7) <= DIN3;
    Unique_Lax_Signal_Name_capin(8) <= DIN4ul;
    Unique_Lax_Signal_Name_trigin(8) <= DIN4ul;
    Unique_Lax_Signal_Name_capin(9) <= DIN4;
    Unique_Lax_Signal_Name_trigin(9) <= DIN4;
    Unique_Lax_Signal_Name_capin(10) <= DIN5ul;
    Unique_Lax_Signal_Name_trigin(10) <= DIN5ul;
    Unique_Lax_Signal_Name_capin(11) <= DIN5;
    Unique_Lax_Signal_Name_trigin(11) <= DIN5;
    Unique_Lax_Signal_Name_capin(12) <= DIN6ul;
    Unique_Lax_Signal_Name_trigin(12) <= DIN6ul;
    Unique_Lax_Signal_Name_capin(13) <= DIN6;
    Unique_Lax_Signal_Name_trigin(13) <= DIN6;
    Unique_Lax_Signal_Name_capin(14) <= DIN7ul;
    Unique_Lax_Signal_Name_trigin(14) <= DIN7ul;
    Unique_Lax_Signal_Name_capin(15) <= DIN7;
    Unique_Lax_Signal_Name_trigin(15) <= DIN7;

    U1 : LAX_CFG16
      Port Map
      (
        CH_CAP    => Unique_Lax_Signal_Name_capin,
        CH_TRIG   => Unique_Lax_Signal_Name_trigin,
        CLK      => CLK,
        CLK_CAP  => CLK_CAP,
        STATUS   => STATUS,
        DATAO    => Unique_Lax_Signal_Name_Mem_DIN,
        DATAI    => Unique_Lax_Signal_Name_Mem_DOUT,
        WR       => Unique_Lax_Signal_Name_Mem_WE,
        RD       => Open,
        ADDR     => Unique_Lax_Signal_Name_Mem_ADDR,
        SEL_CAP  => Unique_Lax_Signal_Name_selcap,
        SEL_TRIG => Unique_Lax_Signal_Name_seltrig,
        TCK      => TCK,
        TDI      => TDI,
        TDO      => TDO,
        TMS      => TMS,
        TRIGGER  => EXT_TRIGGER,
        TRST     => TRST
      );
    U2 : memory_u_lax
      Port Map
      (
        CLK      => CLK,
        DIN      => Unique_Lax_Signal_Name_Mem_DIN,
        DOUT     => Unique_Lax_Signal_Name_Mem_DOUT,
        ADDR     => Unique_Lax_Signal_Name_Mem_ADDR(9 Downto 0),
        WE       => Unique_Lax_Signal_Name_Mem_WE
      );

End structure;
--------------------------------------------------------------------------------
